package com.example.sefinsa_app.ui.rmd;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatDialog;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.text.Editable;
import android.text.TextWatcher;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;

import com.example.sefinsa_app.R;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.rmd.Ver.RMDAdapter;
import com.example.sefinsa_app.utilities.NetworkChange;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;

import org.json.JSONException;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RMDFragment extends Fragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    private String mParam1;
    private String mParam2;

    public RMDFragment() { }

    public static RMDFragment newInstance(String param1, String param2) {
        RMDFragment fragment = new RMDFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    RecyclerView rvRMD;

    TextInputLayout
            tlNombreFolio,
            tlFecha,
            tlRuta,
            tlPoblacion;

    TextInputEditText
            etNombreFolio,
            etFecha;

    AutoCompleteTextView
            acRuta,
            acPoblacion;

    RMDController rmdController;
    ProgressDialog pDialog;

    ArrayList<Ruta> rutas;
    ArrayList<Poblacion> poblaciones;

    ArrayAdapter<Ruta> rutasAdapter;
    ArrayAdapter<Poblacion> poblacionesAdapter;

    String ruta_id = "";
    String poblacion_id = "";

    private SharedPreferences sesion;

    private String fecha = null;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_r_m_d, container, false);

        rmdController = new RMDController(getContext(), getActivity());
        try {
            setGlobalVars(view);
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }

        return view;
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                acRuta.setText("");
                acPoblacion.setText("");
                tlFecha.getEditText().setText("");
                tlNombreFolio.getEditText().setText("");

                tlRuta.getEditText().clearFocus();
                tlPoblacion.getEditText().clearFocus();
                tlNombreFolio.getEditText().clearFocus();

                poblacion_id = "";
                ruta_id = "";
                fecha = null;

                acPoblacion.setAdapter(null);
                acPoblacion.setText("");

                if (NetworkChange.isConnectedToInternet(requireContext())) {
                    try {
                        dbSync();
                    } catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    filtrar();
                }
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    public void setGlobalVars(View view) throws JSONException {
        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        rvRMD = view.findViewById(R.id.rvRMD);

        tlNombreFolio = view.findViewById(R.id.tlNombreFolio);
        tlFecha = view.findViewById(R.id.tlFecha);
        tlRuta = view.findViewById(R.id.tlRuta);
        tlPoblacion = view.findViewById(R.id.tlPoblacion);

        etNombreFolio = view.findViewById(R.id.etNombreFolio);
        etFecha = view.findViewById(R.id.etFecha);
        acRuta = view.findViewById(R.id.acRuta);
        acPoblacion = view.findViewById(R.id.acPoblacion);

        getRutasEmpleado();
        setInputsParaFiltrar();

        if (NetworkChange.isConnectedToInternet(getContext())) {
            dbSync();
        } else {
            filtrar();
        }
    }

    public void getRutasEmpleado() {
        String rutasEmpleado = sesion.getString("rutas", "");
        String[] rutasEmpleadoArr = rutasEmpleado.split(",");

        List<Integer> rutasNumericas = new ArrayList<>();
        for (String rutaStr : rutasEmpleadoArr) {
            try {
                rutasNumericas.add(Integer.parseInt(rutaStr.trim()));
            } catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(rutasNumericas);

        rutas = new ArrayList<>();
        for (int num : rutasNumericas) {
            rutas.add(new Ruta(String.valueOf(num), "RUTA " + num));
        }

        rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_list_item_1, rutas);
        acRuta.setAdapter(rutasAdapter);
        acRuta.setText("");
    }

    public void setInputsParaFiltrar() {
        tlNombreFolio.getEditText().addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                String input = s.toString();

                acRuta.setText("");
                acPoblacion.setText("");
                tlFecha.getEditText().setText("");
                poblacion_id = "";
                ruta_id = "";
                fecha = null;

                // Filtro por folio
                if (input.matches("\\d+")) {
                    setRecycler(rmdController.filtroFolio(input));
                }
                // Filtro si se elimina el texto
                else if (input.isEmpty()) {
                    filtrar();
                }
                // Filtro por nombre
                else {
                    setRecycler(rmdController.filtroNombre(input));
                }
            }
        });

        acRuta.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                Ruta ruta = (Ruta) parent.getItemAtPosition(position);
                ruta_id = ruta.getId();
                poblacion_id = "";

                RutaController rutaController = new RutaController(getContext());

                poblaciones = rutaController.getPoblaciones(ruta_id);

                poblacionesAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_list_item_1, poblaciones);
                acPoblacion.setAdapter(poblacionesAdapter);
                acPoblacion.setText("");

                tlRuta.getEditText().clearFocus();

                filtrar();
            }
        });

        acPoblacion.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                Poblacion poblacion = (Poblacion) parent.getItemAtPosition(position);
                poblacion_id = poblacion.getId();

                tlPoblacion.getEditText().clearFocus();

                filtrar();
            }
        });

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            LocalDate today = LocalDate.now();

            String[] pFecha = String.valueOf(today).split("-");
            tlFecha.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
            fecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
        }

        tlFecha.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                LocalDate today = null;
                String date = null;
                tlNombreFolio.getEditText().setText("");

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    today = LocalDate.now();
                    String[] pFecha = String.valueOf(today).split("-");
                    date = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                }
                if (!Objects.equals(fecha, date)) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                        tlFecha.getEditText().setText(date);
                        fecha = date;
                        filtrar();
                    }
                } else {
                    MaterialDatePicker.Builder<Long> materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                    materialDateBuilder.setTitleText("Fecha");

                    CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder();
                    constraintsBuilder.setEnd(MaterialDatePicker.todayInUtcMilliseconds());

                    materialDateBuilder.setCalendarConstraints(constraintsBuilder.build());

                    MaterialDatePicker<Long> materialDatePicker = materialDateBuilder.build();
                    materialDatePicker.show(getChildFragmentManager(), "MATERIAL_DATE_PICKER");

                    materialDatePicker.addOnPositiveButtonClickListener(
                            new MaterialPickerOnPositiveButtonClickListener<Long>() {
                                @SuppressLint("SetTextI18n")
                                @Override
                                public void onPositiveButtonClick(Long selection) {
                                    TimeZone timeZoneUTC = TimeZone.getDefault();
                                    int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                                    SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                                    Date date = new Date(selection + offsetFromUTC);

                                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                        LocalDate today = LocalDate.now();
                                        Instant instant = date.toInstant();
                                        ZoneId zoneId = ZoneId.systemDefault();
                                        LocalDate selectedDate = instant.atZone(zoneId).toLocalDate();

                                        if (selectedDate.isAfter(today)) {
                                            AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                                            builder.setTitle("Fecha invalida");
                                            builder.setMessage("La fecha ingresada no puede ser mayor a la de hoy.");

                                            builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                                                public void onClick(DialogInterface dialog, int id) {
                                                    dialog.dismiss();
                                                }
                                            });

                                            AlertDialog dialog = builder.create();
                                            dialog.show();
                                        }
                                        else {
                                            String f = simpleFormat.format(date);
                                            String[] pFecha = f.split("-");
                                            String mFecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                                            tlFecha.getEditText().setText(mFecha);

                                            fecha = mFecha;

                                            filtrar();
                                        }
                                    }
                                }
                            });
                }
            }
        });

        filtrar();
    }

    public void dbSync() throws JSONException {
        pDialog = new ProgressDialog(getContext());
        pDialog.setMessage("Cargando datos, por favor espere...");
        pDialog.setCancelable(false);
        pDialog.show();

        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

        scheduler.schedule(new Runnable() {
            @Override
            public void run() {
                pDialog.dismiss();
            }
        }, 25, TimeUnit.SECONDS);

        rmdController = new RMDController(getContext(), getActivity());

        final int[] cargados = {0};
        syncServerApp(new SyncCallback() {
            @Override
            public void onSuccess() {
                cargados[0]++;
                if (cargados[0] >= 3) {
                    pDialog.dismiss();
                    filtrar();
                }
            }
        });

        syncEdit(new SyncCallback() {
            @Override
            public void onSuccess() {
                cargados[0]++;
                if (cargados[0] >= 3) {
                    pDialog.dismiss();
                    filtrar();
                }
            }
        });

        syncAppServer(new SyncCallback() {
            @Override
            public void onSuccess() {
                cargados[0]++;
                if (cargados[0] >= 3) {
                    pDialog.dismiss();
                    filtrar();
                }
            }
        });
    }

    public interface SyncCallback {
        void onSuccess();
    }

    public void syncServerApp(SyncCallback callback) {
        rmdController.getCountRMDsServidor(new RMDController.GetCountRMDsServidorCallback() {
            @Override
            public void onSuccess(int n) {
                int c = rmdController.getRMDSCount();
                if (c == n) {
                    callback.onSuccess();
                } else {
                    rmdController.getRMDSinSincronizar(new RMDController.GetRMDsSinSincronizarCallback() {
                        @Override
                        public void onSuccess(ArrayList<RMD> rmds) {
                            if (rmds != null && !rmds.isEmpty()) {
                                final int[] n = {0};
                                for (RMD rmd : rmds) {
                                    rmdController.intertarRMDServidor(rmd, new RMDController.SincronizarDelServidorCallback() {
                                        @Override
                                        public void onSuccess() {
                                            n[0]++;

                                            if (n[0] == rmds.size()) {
                                                callback.onSuccess();
                                            }
                                        }

                                        @Override public void onError(String error) { }
                                    });
                                }
                            }
                        }

                        @Override public void onError(String error) { }
                    });
                }

            }

            @Override
            public void onError(String error) {
                Log.d("ERROR", "onError: " + error);
            }
        });
    }

    public void syncEdit(SyncCallback callback) throws JSONException {
        rmdController.getRMDsEditados();
        callback.onSuccess();
    }

    public void syncAppServer(SyncCallback callback) {
        ArrayList<RMD> rmds = rmdController.getRMDsDesincronizados();

        if (rmds != null && !rmds.isEmpty()) {
            sincronizar(rmds);
            callback.onSuccess();
        } else {
            callback.onSuccess();
        }
    }

    public void filtrar() {
        // Filtrar si hay fecha
        if (fecha != null) {
            // Filtrar si hay poblacion
            if (!Objects.equals(poblacion_id, "")) {
                setRecycler(rmdController.filtroPoblacionFecha(fecha, poblacion_id));
            }
            // Filtrar si hay ruta
            else if (!Objects.equals(ruta_id, "")) {
                setRecycler(rmdController.filtroRutaFecha(fecha, ruta_id));
            }
            // Filtrar si hay fecha pero no hay ruta ni poblacion
            else {
                setRecycler(rmdController.filtroFecha(fecha));
            }
            // Si no hay fecha, poner fecha actual y volver a llamar a la misma funcion
        } else {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                LocalDate today = LocalDate.now();

                String[] pFecha = String.valueOf(today).split("-");
                tlFecha.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
                fecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];

                filtrar();
            }
        }
    }

    public void setRecycler(ArrayList<RMD> rmds) {
        RMDAdapter adapter = new RMDAdapter(rmds, this, getContext(), getActivity());
        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(getContext());
        rvRMD.setLayoutManager(layoutManager);
        rvRMD.setItemAnimator(new DefaultItemAnimator());
        rvRMD.setAdapter(adapter);
    }

    public File generarPDF(String content, String fc, String fa, String folio) throws IOException {
        File pdfFile = new File(getContext().getCacheDir(), "RMD" + folio + ".pdf");
        PdfWriter writer = new PdfWriter(pdfFile);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);

        Drawable drawable = getResources().getDrawable(R.drawable.sefinsa_ticket);
        BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
        ImageData imageData = ImageDataFactory.create(stream.toByteArray());
        Image image = new Image(imageData);
        document.add(image);

        Paragraph p = new Paragraph(content);
        p.setFontSize(6);
        document.add(p);

        Paragraph p2 = new Paragraph("Firma del cliente: \n");
        p2.setFontSize(8);
        document.add(p2);

        byte[] decodedBytes2 = Base64.decode(fc, Base64.DEFAULT);
        bitmap = BitmapFactory.decodeByteArray(decodedBytes2, 0, decodedBytes2.length);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos2);
        ImageData imageData3 = ImageDataFactory.create(baos2.toByteArray());
        Image image3 = new Image(imageData3);
        image3.scaleToFit(100, 100);
        document.add(image3);

        Paragraph p3 = new Paragraph("Firma del asesor: \n");
        p3.setFontSize(8);
        document.add(p3);

        byte[] decodedBytes = Base64.decode(fa, Base64.DEFAULT);
        bitmap = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos1);
        ImageData imageData2 = ImageDataFactory.create(baos1.toByteArray());
        Image image2 = new Image(imageData2);
        image2.scaleToFit(100, 100);
        document.add(image2);

        // Cerrar el documento
        document.close();

        return pdfFile;
    }

    public void compartirPDF(File pdfFile) {
        try {
            Intent intent = new Intent(Intent.ACTION_SEND);
            intent.setType("application/pdf");
            Uri pdfUri = FileProvider.getUriForFile(getContext(), getContext().getApplicationContext().getPackageName() + ".provider", pdfFile);
            intent.putExtra(Intent.EXTRA_STREAM, pdfUri);
            startActivity(Intent.createChooser(intent, "Compartir mediante"));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    public void sincronizar(ArrayList<RMD> rmds) {
        final int[] c = {0};
        for (RMD rmd : rmds) {
            rmdController.subirRMDsDesincronizadosServidor(rmd, new RMDController.SubirRMDsDesincronizadosServidorCallback() {
                @Override
                public void onSuccess() {
                    c[0]++;

                    Log.d("aklsdklaskld", c[0] + " / " + rmds.size());

                    if (c[0] == rmds.size()) {
                        pDialog.dismiss();
                        filtrar();
                    }
                }

                @Override
                public void onError(String error) {

                }
            });
        }
    }
}